"use client"

import { ButtonIconProps, ButtonProps, buttonVariants } from "@/components/ui/button";
import { cn } from "@/lib/utils";
import React from "react";
import { Slot, Slottable } from "@radix-ui/react-slot";
import { Edit, Expand, PlusIcon, XIcon } from "lucide-react";
import { ExclamationTriangleIcon } from "@radix-ui/react-icons";
import { focusInput } from "@/lib/styles";
import { WorkflowTag } from "@/types/workflow";

export const WorkflowButton = React.forwardRef<
  HTMLButtonElement,
  ButtonProps & ButtonIconProps & {
    step: WorkflowTag
  }>(
    (
      {
        className,
        variant = "outline",
        size = "icon",
        asChild = false,
        Icon,
        iconPlacement,
        step,
        ...props
      },
      ref
    ) => {

      const Comp = asChild ? Slot : "button";
      const fallback = INTERNAL__getFallbackContent(step)

      return (
        <Comp
          aria-label="Add a new statewide service."
          className={cn(focusInput, buttonVariants({ variant, size, className }))}
          ref={ref}
          {...props}
        >
          {Icon && iconPlacement === "left" && (
            <div className="w-0 translate-x-[0%] pr-0 opacity-0 transition-all duration-200 group-hover:w-5 group-hover:translate-x-100 group-hover:pr-2 group-hover:opacity-100">
              <Icon className="size-3" />
            </div>
          )}
          <Slottable>{props.children || <fallback.Icon className="size-3" />}</Slottable>
          {Icon && iconPlacement === "right" && (
            <div className="w-0 translate-x-[100%] pl-0 opacity-0 transition-all duration-200 group-hover:w-5 group-hover:translate-x-0 group-hover:pl-2 group-hover:opacity-100">
              <Icon className="size-3" />
            </div>
          )}
        </Comp>
      );
    }
  );
WorkflowButton.displayName = "WorkflowButton";

function INTERNAL__getFallbackContent(step: WorkflowTag) {
  if (step === "ADD_SERVICE") {
    return {
      Icon: PlusIcon,
    }
  }

  if (step === "VIEW_SERVICES") {
    return {
      Icon: Expand,
    }
  }

  if (step === "UPDATE_SERVICE") {
    return {
      Icon: Edit,
    }
  }

  if (step === "DELETE_SERVICE") {
    return {
      Icon: XIcon,
    }
  }

  return {
    Icon: ExclamationTriangleIcon,
  }
}
